wk.matrix <- c(biota["Chlorobiphenyls"], sediment[c("Chlorobiphenyls", "Organo-metals")])

# number of status stations by region (incl. non-parametric fits)


lapply(wk.matrix, function(assessment) {
  
  out <- assessment$timeSeries[c("region", "country", "station", "determinand", "shape", "colour", "nypos", "paramFit")]

  out <- droplevels(out[out$shape != "open_circle", ])
  out <- within(out, region <- factor(region, levels = rev(levels(region))))

  out <- cbind(
    with(unique(out[c("region", "country", "station")]), table(region)), 
    with(out, table(region, determinand))
  )
  
  out <- as.data.frame.matrix(out)
  names(out)[1] <- "stations"
  write.csv(out, file.path("tables for Jen", paste0(assessment$ID, " status all.csv")))
})



# number of status stations by region used in regional assessmenet

lapply(wk.matrix, function(assessment) {
  
  out <- assessment$status[c("region", "country", "station", "determinand", "shape", "colour")]
  out <- within(out, region <- factor(region, levels = rev(levels(region))))
  
  out <- cbind(
    with(unique(out[c("region", "country", "station")]), table(region)), 
    with(out, table(region, determinand))
  )
  
  out <- as.data.frame.matrix(out)
  names(out)[1] <- "stations"
  write.csv(out, file.path("tables for Jen", paste0(assessment$ID, " status regional assessment.csv")))
})


# and now trend stations by region (incl. impacted)

lapply(wk.matrix, function(assessment) {
  
  out <- assessment$timeSeries[c("region", "country", "station", "determinand", "shape", "colour", "nypos", "paramFit")]
  out <- within(out, region <- factor(region, levels = rev(levels(region))))
  
  out <- droplevels(out[out$nypos >= 5, ])
  
  out <- cbind(
    with(unique(out[c("region", "country", "station")]), table(region)), 
    with(out, table(region, determinand))
  )
  
  out <- as.data.frame.matrix(out)
  names(out)[1] <- "stations"
  write.csv(out, file.path("tables for Jen", paste0(assessment$ID, " trend all.csv")))
})



# and used in regional assessmenet

lapply(wk.matrix, function(assessment) {
  
  out <- assessment$trend[c("region", "country", "station", "determinand", "shape", "colour")]
  out <- within(out, region <- factor(region, levels = rev(levels(region))))
  
  out <- cbind(
    with(unique(out[c("region", "country", "station")]), table(region)), 
    with(out, table(region, determinand))
  )
  
  out <- as.data.frame.matrix(out)
  names(out)[1] <- "stations"
  write.csv(out, file.path("tables for Jen", paste0(assessment$ID, " trend regional assessment.csv")))
})



wk.matrix <- c(biota[c("PAH (parent)", "Organo-bromines")], sediment[c("PAH (parent)", "Organo-bromines")])

# number of trend and status stations by region (incl. non-parametric fits)


lapply(wk.matrix, function(assessment) {
  
  timeSeries <- assessment$timeSeries[c("region", "country", "station", "determinand", "shape", "colour", "nypos", "paramFit")]
  
  status <- droplevels(timeSeries[timeSeries$shape != "open_circle", ])
  status <- within(status, region <- factor(region, levels = rev(levels(region))))

  trend <- timeSeries[timeSeries$nypos >= 5, ]
  trend <- within(trend, region <- factor(region, levels = levels(status$region)))
  
  out <- do.call(cbind, lapply(list(trend, status), function(data) {
    with(unique(data[c("region", "country", "station")]), table(region))
  }))
  
  out <- as.data.frame.matrix(out)
  names(out) <- c("trend", "status")
  write.csv(out, file.path("tables for Jen", paste0(assessment$ID, " all.csv")))
})


# and for regional assessment

lapply(wk.matrix, function(assessment) {
  
  status <- assessment$status
  status <- within(status, region <- factor(region, levels = rev(levels(region))))

  trend <- assessment$trend
  trend <- within(trend, region <- factor(region, levels = levels(status$region)))
  
  out <- do.call(cbind, lapply(list(trend, status), function(data) {
    with(unique(data[c("region", "country", "station")]), table(region))
  }))

  out <- as.data.frame.matrix(out)
  names(out) <- c("trend", "status")
  write.csv(out, file.path("tables for Jen", paste0(assessment$ID, " regional assessment.csv")))
})


wk.matrix <- c(biota["Metals"], sediment["Metals"])

# number of trend and status stations by region (incl. non-parametric fits)


lapply(wk.matrix, function(assessment) {
  
  timeSeries <- assessment$timeSeries[c("region", "country", "station", "determinand", "shape", "colour", "nypos")]
  
  status <- droplevels(timeSeries[timeSeries$shape != "open_circle", ])
  status <- within(status, region <- factor(region, levels = rev(levels(region))))
  
  trend <- timeSeries[timeSeries$nypos >= 5, ]
  trend <- within(trend, region <- factor(region, levels = levels(status$region)))
  
  out <- do.call(cbind, lapply(list(status, trend), function(data) {
    with(unique(data[c("region", "country", "station", "determinand")]), table(region, determinand))
  }))
  
  out <- as.data.frame.matrix(out)
  names(out) <- paste(rep(c("status", "trend"), each = 3), names(out), sep = "_")
  write.csv(out, file.path("tables for Jen", paste0(assessment$ID, " all.csv")))
})


# and for regional assessment

lapply(wk.matrix, function(assessment) {
  
  status <- assessment$status
  status <- within(status, region <- factor(region, levels = rev(levels(region))))
  
  trend <- assessment$trend
  trend <- within(trend, region <- factor(region, levels = levels(status$region)))
  
  out <- do.call(cbind, lapply(list(status, trend), function(data) {
    with(unique(data[c("region", "country", "station", "determinand")]), table(region, determinand))
  }))
  
  out <- as.data.frame.matrix(out)
  names(out) <- paste(rep(c("status", "trend"), each = 3), names(out), sep = "_")
  write.csv(out, file.path("tables for Jen", paste0(assessment$ID, " regional assessment.csv")))
})



wk.matrix <- biota["Imposex"]

# number of time series by region and species


lapply(wk.matrix, function(assessment) {
  
  timeSeries <- assessment$timeSeries[c("region", "country", "station", "species", "determinand", "shape", "colour", "nypos")]
  
  status <- droplevels(timeSeries[timeSeries$shape != "open_circle", ])
  status <- within(status, region <- factor(region, levels = rev(levels(region))))
  
  out <- with(status, table(region, species))
  out <- as.data.frame.matrix(out)
  write.csv(out, file.path("tables for Jen", paste0(assessment$ID, " table a all.csv")))
  
  
  status <- assessment$status
  status <- within(status, region <- factor(region, levels = rev(levels(region))))

  out <- with(status, table(region, species))
  out <- as.data.frame.matrix(out)
  write.csv(out, file.path("tables for Jen", paste0(assessment$ID, " table a regional assessment.csv")))
})



lapply(wk.matrix, function(assessment) {
  
  timeSeries <- assessment$timeSeries[
    c("region", "country", "station", "species", "determinand", "shape", "colour", "nypos")]
  
  status <- droplevels(timeSeries[timeSeries$shape != "open_circle" & timeSeries$colour != "black", ])
  status <- within(status, region <- factor(region, levels = rev(levels(region))))
  
  trend <- timeSeries[timeSeries$nypos >= 5, ]
  trend <- within(trend, region <- factor(region, levels = levels(status$region)))

  out <- do.call(cbind, lapply(list(status, trend), function(data) {
    with(unique(data[c("region", "country", "station")]), table(region))
  }))
  
  out <- as.data.frame.matrix(out)
  names(out) <- c("status_all", "trend_all")
  
  
  status <- assessment$status
  status <- droplevels(status[status$colour != "black", ])
  status <- within(status, region <- factor(region, levels = rev(levels(region))))

  trend <- assessment$trend
  trend <- within(trend, region <- factor(region, levels = levels(status$region)))
  
  out2 <- do.call(cbind, lapply(list(status, trend), function(data) {
    with(unique(data[c("region", "country", "station")]), table(region))
  }))
  
  out2 <- as.data.frame.matrix(out2)
  names(out2) <- c("status_regional", "trend_regional")
  
  out <- cbind(out, out2)
  out <- out[c("status_all", "status_regional", "trend_all", "trend_regional")]
  
  write.csv(out, file.path("tables for Jen", paste0(assessment$ID, " table d.csv")))
})



lapply(wk.matrix, function(assessment) {
  
  out <- assessment$timeSeries[c("region", "country", "station", "determinand", "shape", "colour", "nypos")]
  
  out <- droplevels(out[out$nypos >= 5, ])
  out <- within(out, {
    region <- factor(region, levels = rev(levels(region)))
    shape <- factor(shape, levels = c("downward_triangle", "filled_circle", "upward_triangle"))
  })
  
  out1 <- with(unique(out[c("region", "country", "station")]), table(region))
  out2 <- with(out, table(region, shape))
  out2 <- round(100 * out2 / rowSums(out2))
  
  out <- cbind(out2, out1)
  out <- as.data.frame.matrix(out)
  names(out) <- c("decreasing", "stable", "increasing", "station")
  
  write.csv(out, file.path("tables for Jen", paste0(assessment$ID, " table 1.csv")))
})
